% Script_NOB_PRM_Slices_Creation

% Este script cria uma pasta FILES e salva nela os arquivos
% "NumberOfBits_XX_Bits.mat", "PRM_XX_Bits.mat" e "Slices_XX_Bits.mat",
% onde XX vai de 12 a 309, de 3 em 3. O script tambem salva na pasta raiz o
% arquivo "20101129T174800_Table_PRM_Slices_NumberOfBits.mat".

% Estes arquivos Slices, PRM e NumberOfBits criados por este script foram
% depois copiados para a pasta "90 Configuration Data" para serem usados na
% LUT caoticas

% Each line of PRM table is calculated based on the avaliable data of each Parallelepiped_Limits file calculated on the Egodicity Simulations and saved on hard disk
% PRM_Title = 'PRM - Paralellepiped Relations Measurements';
% PRM_Columns_1 = '01) DimXMinInt, 02) DimXMinDec, 03) XMin, 04) XMax, 05) VarX, 06) DimVarXInt, 07) DimVarXDec, 08) Separator for help visuaization (Empty),'; 
% PRM_Columns_2 = '09) DimYMinInt, 10) DimYMinDec, 11) YMin, 12) YMax, 13) VarY, 14) DimVarYInt, 15) DimVarYDec, 16) Separator for help visuaization (Empty),'; 
% PRM_Columns_3 = '17) DimZMinInt, 18) DimZMinDec, 19) ZMin, 20) ZMax, 21) VarZ, 22) DimVarZInt, 23) DimVarZDec, 24) Separator for help visuaization (Empty),'; 
% PRM_Columns_4 = '25) Year, 26) Month, 27) Day, 28) Hour, 29) Minute, 30) Second, 31) Is it Valid?, 32) Volume, 33) DiscretizationCriteria, 34) Separator for help visuaization (Empty),'; 

% Slices = ones(Linnes,3); 
% 3 Columns: Offset of Top Bit relative to LSB, Offset of Botton Bit relative to LSB, Number of Bits on slice (difference top botton)

% Cada NumberOfBits esta associado a uma tabela PRM com 1 ou mais linhas, e cada linha do PRM gera 3 linhas da tabela Slice (o que corresponde a 9 valores pois a tabela tem 3 colunas)
% Table_PRM_Slices_NumberOfBits_Title = 'Table_PRM_Slices_NumberOfBits - Table that sumirizes the data (PRM, Slice and NumberOfBits) for All bits';
% Table_PRM_Slices_NumberOfBits_Columns_1 = 'On column 01 we have the NumberOfBits value for the chaotic LUT. 01) Number of Bits';
% Table_PRM_Slices_NumberOfBits_Columns_2 = 'On column 02 we have the number of lines of tabel PRM. 02) Number of lines of table PRM';
% Table_PRM_Slices_NumberOfBits_Columns_3 = 'On column 03 we have the Separator for help visuaization (Empty). 03) Separator for help visuaization (Empty)';
% Table_PRM_Slices_NumberOfBits_Columns_4 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 01) DimXMinInt, 02) DimXMinDec, 03) XMin, 04) XMax, 05) VarX, 06) DimVarXInt, 07) DimVarXDec, 08) Separator for help visuaization (Empty),'; 
% Table_PRM_Slices_NumberOfBits_Columns_5 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 09) DimYMinInt, 10) DimYMinDec, 11) YMin, 12) YMax, 13) VarY, 14) DimVarYInt, 15) DimVarYDec, 16) Separator for help visuaization (Empty),'; 
% Table_PRM_Slices_NumberOfBits_Columns_6 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 17) DimZMinInt, 18) DimZMinDec, 19) ZMin, 20) ZMax, 21) VarZ, 22) DimVarZInt, 23) DimVarZDec, 24) Separator for help visuaization (Empty),'; 
% Table_PRM_Slices_NumberOfBits_Columns_7 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 25) Year, 26) Month, 27) Day, 28) Hour, 29) Minute, 30) Second, 31) Is it Valid?, 32) Volume, 33) DiscretizationCriteria, 34) Separator for help visuaization (Empty),'; 
% Table_PRM_Slices_NumberOfBits_Columns_8 = 'From columns 38 to 46 we have the 9 values (refered to each line of PRM) of table Slices ordered from left to rigth, top to down. 35) Offset of Top Bit relative to LSB, 36) Offset of Botton Bit relative to LSB, 37) Number of Bits on slice (difference top botton)'; 
% Table_PRM_Slices_NumberOfBits_Columns_9 = 'On column 47 we have the Separator for help visuaization (Empty). 47) Separator for help visuaization (Empty)';
% Table_PRM_Slices_NumberOfBits_Columns_10 = 'From columns 48 to 49 we have the ASIC forecast Area and Power of the XX Bits Chaotic LUT'; 


clear

TimeStart = datevec(now);

% open Script_NOB_PRM_Slices_Creation.m
copyfile('Script_NOB_PRM_Slices_Creation.m',['', DATESTR(datenum(TimeStart),30), '_Script_NOB_PRM_Slices_Creation.m']);
eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Files']);

Empty = 9999; % Used on PRM table as a separator between blocks of data (DimX, DimY, DimZ, Date) to help the visualization

Second = 1/86400; % This express one second in terms of a day (a day has 86400 seconds)
DateStart1 = datenum(2024,01,17,11,22,52);   % Esta linha serah usada para abrir o arquivo "20240117T112252_Parallelepiped.mat" na pasta "SC-LUT All Bits\92 Addressing All Bits\6 Big Parallelepiped"
DateEnd1 =   datenum(2024,01,17,11,22,52);
DateStart2 = datenum(2024,01,17,11,25,55);   % Esta linha serah usada para abrir o arquivo "20240117T112555_Parallelepiped.mat" na pasta "SC-LUT All Bits\92 Addressing All Bits\6 Big Parallelepiped"
DateEnd2 =   datenum(2024,01,17,11,25,55);
DateStart3 = datenum(2024,01,17,11,27,32);   % Esta linha serah usada para abrir o arquivo "20240117T112732_Parallelepiped.mat" na pasta "SC-LUT All Bits\92 Addressing All Bits\6 Big Parallelepiped"
DateEnd3 =   datenum(2024,01,17,11,27,32);
DateStart4 = datenum(2024,01,17,11,29,40);   % Esta linha serah usada para abrir o arquivo "20240117T112940_Parallelepiped.mat" na pasta "SC-LUT All Bits\92 Addressing All Bits\6 Big Parallelepiped"
DateEnd4 =   datenum(2024,01,17,11,29,40);
DateStart5 = datenum(2024,01,17,11,31,20);   % Esta linha serah usada para abrir o arquivo "20240117T113120_Parallelepiped.mat" na pasta "SC-LUT All Bits\92 Addressing All Bits\6 Big Parallelepiped"
DateEnd5 =   datenum(2024,01,17,11,31,20);

% Cada NumberOfBits esta associado a uma tabela PRM com 1 ou mais linhas, e cada linha do PRM gera 3 linhas da tabela Slice (o que corresponde a 9 valores pois a tabela tem 3 colunas)

Table_PRM_Slices_NumberOfBits_Title = 'Table_PRM_Slices_NumberOfBits - Table that sumirizes the data (PRM, Slice and NumberOfBits) for All bits';
Table_PRM_Slices_NumberOfBits_Columns_1 = 'On column 01 we have the NumberOfBits value for the chaotic LUT. 01) Number of Bits';
Table_PRM_Slices_NumberOfBits_Columns_2 = 'On column 02 we have the number of lines of tabel PRM. 02) Number of lines of table PRM';
Table_PRM_Slices_NumberOfBits_Columns_3 = 'On column 03 we have the Separator for help visuaization (Empty). 03) Separator for help visuaization (Empty)';
Table_PRM_Slices_NumberOfBits_Columns_4 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 01) DimXMinInt, 02) DimXMinDec, 03) XMin, 04) XMax, 05) VarX, 06) DimVarXInt, 07) DimVarXDec, 08) Separator for help visuaization (Empty),'; 
Table_PRM_Slices_NumberOfBits_Columns_5 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 09) DimYMinInt, 10) DimYMinDec, 11) YMin, 12) YMax, 13) VarY, 14) DimVarYInt, 15) DimVarYDec, 16) Separator for help visuaization (Empty),'; 
Table_PRM_Slices_NumberOfBits_Columns_6 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 17) DimZMinInt, 18) DimZMinDec, 19) ZMin, 20) ZMax, 21) VarZ, 22) DimVarZInt, 23) DimVarZDec, 24) Separator for help visuaization (Empty),'; 
Table_PRM_Slices_NumberOfBits_Columns_7 = 'From columns 04 to 37 we have the 34 columns of an line X of PRM table. 25) Year, 26) Month, 27) Day, 28) Hour, 29) Minute, 30) Second, 31) Is it Valid?, 32) Volume, 33) DiscretizationCriteria, 34) Separator for help visuaization (Empty),'; 
Table_PRM_Slices_NumberOfBits_Columns_8 = 'From columns 38 to 46 we have the 9 values (refered to each line of PRM) of table Slices ordered from left to rigth, top to down. 35) Offset of Top Bit relative to LSB, 36) Offset of Botton Bit relative to LSB, 37) Number of Bits on slice (difference top botton)'; 
Table_PRM_Slices_NumberOfBits_Columns_9 = 'On column 47 we have the Separator for help visuaization (Empty). 47) Separator for help visuaization (Empty)';
Table_PRM_Slices_NumberOfBits_Columns_10 = 'From columns 48 to 49 we have the ASIC forecast Area and Power of the XX Bits Chaotic LUT'; 
Table_PRM_Slices_NumberOfBits = ones(1,49); 
Table_PRM_Slices_NumberOfBits = 987654321*Table_PRM_Slices_NumberOfBits;
Table_PRM_Slices_NumberOfBits_Line_Index = 1;

% The number of Simulations is equal to the product of the number of xzero, yzero and zzero used
PercentageProgress = 3;
DiscretizationCriteriaMax = 150;
NumberSimulationsTotal = DiscretizationCriteriaMax;
NumberSimulationsLeft = NumberSimulationsTotal; % Before starting the simulation, the NumberSimulationsLeft is equal to the  NumberSimulationsTotal

for DC = 1:1:DiscretizationCriteriaMax;

	DiscretizationCriteria = DC;
	
	NumberOfBits = 0;
	
	PRM_Title = 'PRM - Paralellepiped Relations Measurements';
	PRM_Columns_1 = '01) DimXMinInt, 02) DimXMinDec, 03) XMin, 04) XMax, 05) VarX, 06) DimVarXInt, 07) DimVarXDec, 08) Separator for help visuaization (Empty),'; 
	PRM_Columns_2 = '09) DimYMinInt, 10) DimYMinDec, 11) YMin, 12) YMax, 13) VarY, 14) DimVarYInt, 15) DimVarYDec, 16) Separator for help visuaization (Empty),'; 
	PRM_Columns_3 = '17) DimZMinInt, 18) DimZMinDec, 19) ZMin, 20) ZMax, 21) VarZ, 22) DimVarZInt, 23) DimVarZDec, 24) Separator for help visuaization (Empty),'; 
	PRM_Columns_4 = '25) Year, 26) Month, 27) Day, 28) Hour, 29) Minute, 30) Second, 31) Is it Valid?, 32) Volume, 33) DiscretizationCriteria, 34) Separator for help visuaization (Empty),'; 
	PRM = ones(1,34); % % 34 Columns: 01 to 08: DimXMinInt, DimXMinDec, XMin, XMax, VarX, DimVarXInt, DimVarXDec, Empty, 09 to 16: DimYMinInt, DimYMinDec, YMin, YMax, VarY, DimVarYInt, DimVarYDec, Empty, 17 to 24: DimZMinInt, DimZMinDec, ZMin, ZMax, VarZ, DimVarZInt, DimVarZDec, Empty, 25 to 34: Year, Month, Day, Hour, Minute, Second, Is it Valid?, Volume, DiscretizationCriteria, Empty, Second = 1/86400; % This express one second in terms of a day (a day has 86400 seconds)
	PRM = 987654321*PRM;
	
	TimeStartEnd = [DateStart3];
% 	TimeStartEnd = [DateStart1:Second:DateEnd1 DateStart2:Second:DateEnd2 DateStart3:Second:DateEnd3 DateStart4:Second:DateEnd4 DateStart5:Second:DateEnd5];
	
	Index_PRM_Lines = 1; % Pointer used for the lines of PRM table
	
	
	for i = TimeStartEnd;

        cd '6 Big Parallelepiped';

        DataHoraVetor = datevec(i);
        DataHora = datestr(DataHoraVetor,30);
        fid1 = fopen([DataHora, '_Parallelepiped.mat']);
        
        if fid1 ~= -1
			load([DataHora, '_Parallelepiped.mat']);
            % Each line of PRM table is calculated based on the avaliable data of each Parallelepiped_Limits file calculated on the Egodicity Simulations and saved on hard disk
            PRM(Index_PRM_Lines,01) = 1 + 1 + ceil(log2(ceil(abs(Parallelepiped_Limits(1,2))))); % 34 Columns: 01 to 08: DimXMinInt, DimXMinDec, XMin, XMax, VarX, DimVarXInt, DimVarXDec, Empty,
            PRM(Index_PRM_Lines,02) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,03) = Parallelepiped_Limits(1,2);
            PRM(Index_PRM_Lines,04) = Parallelepiped_Limits(1,1);
            PRM(Index_PRM_Lines,05) = Parallelepiped_Limits(1,1) - Parallelepiped_Limits(1,2); 
            PRM(Index_PRM_Lines,06) = log2(Parallelepiped_Limits(1,1) - Parallelepiped_Limits(1,2)) + 0;
            PRM(Index_PRM_Lines,07) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,08) = Empty; 
            PRM(Index_PRM_Lines,09) = 1 + 1 + ceil(log2(ceil(abs(Parallelepiped_Limits(1,4))))); % 09 to 16: DimYMinInt, DimYMinDec, YMin, YMax, VarY, DimVarYInt, DimVarYDec, Empty, 
            PRM(Index_PRM_Lines,10) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,11) = Parallelepiped_Limits(1,4); 
            PRM(Index_PRM_Lines,12) = Parallelepiped_Limits(1,3); 
            PRM(Index_PRM_Lines,13) = Parallelepiped_Limits(1,3) - Parallelepiped_Limits(1,4); 
            PRM(Index_PRM_Lines,14) = log2(Parallelepiped_Limits(1,3) - Parallelepiped_Limits(1,4)) + 0;
            PRM(Index_PRM_Lines,15) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,16) = Empty; 
            PRM(Index_PRM_Lines,17) = 1 + 1 + ceil(log2(ceil(abs(Parallelepiped_Limits(1,6))))); % 17 to 24: DimZMinInt, DimZMinDec, ZMin, ZMax, VarZ, DimVarZInt, DimVarZDec, Empty, 
            PRM(Index_PRM_Lines,18) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,19) = Parallelepiped_Limits(1,6); 
            PRM(Index_PRM_Lines,20) = Parallelepiped_Limits(1,5);
            PRM(Index_PRM_Lines,21) = Parallelepiped_Limits(1,5) - Parallelepiped_Limits(1,6);
            PRM(Index_PRM_Lines,22) = log2(Parallelepiped_Limits(1,5) - Parallelepiped_Limits(1,6)) + 0;
            PRM(Index_PRM_Lines,23) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,24) = Empty; 
            PRM(Index_PRM_Lines,25) = DataHoraVetor(1,1); % 25 to 34: Year, Month, Day, Hour, Minute, Second, Is it Valid?, Volume, DiscretizationCriteria, Empty,
            PRM(Index_PRM_Lines,26) = DataHoraVetor(1,2);
            PRM(Index_PRM_Lines,27) = DataHoraVetor(1,3);
            PRM(Index_PRM_Lines,28) = DataHoraVetor(1,4);
            PRM(Index_PRM_Lines,29) = DataHoraVetor(1,5);
            PRM(Index_PRM_Lines,30) = DataHoraVetor(1,6);
            PRM(Index_PRM_Lines,31) = Parallelepiped_Is_It_Valid;
            PRM(Index_PRM_Lines,32) = Parallelepiped_Volume;
            PRM(Index_PRM_Lines,33) = DiscretizationCriteria;
            PRM(Index_PRM_Lines,34) = Empty;
            NumberOfBits = NumberOfBits + PRM(Index_PRM_Lines,06)+PRM(Index_PRM_Lines,07) + PRM(Index_PRM_Lines,14)+PRM(Index_PRM_Lines,15) + PRM(Index_PRM_Lines,22)+PRM(Index_PRM_Lines,23);
            Index_PRM_Lines = Index_PRM_Lines + 1;
        end % if fid1 ~= -1
        clear(['Parallelepiped_', '*']);
		cd .. % cd '6 Big Parallelepiped';
	
        NumberSimulationsLeft = NumberSimulationsLeft - 1;
        % Calculation of End of Simulation Time    
        TimeActual = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]
        TimeElapsed = datenum(TimeActual) - datenum(TimeStart); % Time is numerical form in reference to 01JAN0000
        TimeEnd = datenum(TimeActual) + (TimeElapsed/(NumberSimulationsTotal-NumberSimulationsLeft))*(NumberSimulationsLeft);
        Percentage = 100*(NumberSimulationsTotal-NumberSimulationsLeft)/(NumberSimulationsTotal);
        if Percentage > PercentageProgress
            fprintf(1,'%2.0f%% done. Starts: %s. Now: %s. End: %s \n', Percentage, datestr(TimeStart), datestr(now), datestr(TimeEnd))
            PercentageProgress = PercentageProgress + 10;
        end % Percentage > PercentageProgress
        
	end % for i = TimeStartEnd;
	
	% Each line of PRM synthesizes the data of 1 big parallelepiped (LVICR - Largest Valid Initial Condition Region) of the given Chaotic Equation.
	% We multiply the number of lines of PRM by 3 because each LVICR is used by 1 chaotic equation, and each chaotic equation outputs 3 chaotic variables that should be sliced to form the LUT output.
	Linnes = size(PRM,1)*3; 
	Slices = ones(Linnes,3); % 3 Columns: Offset of Top Bit relative to LSB, Offset of Botton Bit relative to LSB, Number of Bits on slice (difference top botton)
	Slices = 987654321*Slices;
	
	Index_K = 1;
	
	for Slice_Index = [1:3:Linnes]
        
        if Slice_Index == 1
            Slices(Slice_Index,1) = NumberOfBits - 1;
        else
            Slices(Slice_Index,1) = Slices(Slice_Index-1,2) - 1;
        end
         
		Slices(Slice_Index,2) = Slices(Slice_Index,1) - PRM(Index_K,06) - PRM(Index_K,07) + 1;
		Slices(Slice_Index,3) = Slices(Slice_Index,1) - Slices(Slice_Index,2) + 1;
		
		Slices(Slice_Index+1,1) = Slices(Slice_Index,2) - 1;
		Slices(Slice_Index+1,2) = Slices(Slice_Index+1,1) - PRM(Index_K,14) - PRM(Index_K,15) + 1;
		Slices(Slice_Index+1,3) = Slices(Slice_Index+1,1) - Slices(Slice_Index+1,2) + 1;
		
		Slices(Slice_Index+2,1) = Slices(Slice_Index+1,2) - 1;
		Slices(Slice_Index+2,2) = Slices(Slice_Index+2,1) - PRM(Index_K,22) - PRM(Index_K,23) + 1;
		Slices(Slice_Index+2,3) = Slices(Slice_Index+2,1) - Slices(Slice_Index+2,2) + 1;
        
        Index_K = Index_K + 1;
	
	end
	
    eval(['cd ', DATESTR(datenum(TimeStart),30), '_Files']);
    
	% Now that we finished simulating all Initial Condictions, we can save the table of BAD ICs
	if PRM(1,1) ~= 987654321;
% 		filename = (['', DATESTR(datenum(TimeStart),30), '_PRM_', num2str(NumberOfBits),'_Bits.mat']);
		filename = (['PRM_', num2str(NumberOfBits),'_Bits.mat']);
		eval(['save(filename,''PRM'')']);
	end
	if NumberOfBits ~= 0;
%         filename = (['', DATESTR(datenum(TimeStart),30), '_NumberOfBits_', num2str(NumberOfBits),'_Bits.mat']);
        filename = (['NumberOfBits_', num2str(NumberOfBits),'_Bits.mat']);
		eval(['save(filename,''NumberOfBits'')']);
	end
	if Slices ~= 987654321;
%         filename = (['', DATESTR(datenum(TimeStart),30), '_Slices_', num2str(NumberOfBits),'_Bits.mat']);
        filename = (['Slices_', num2str(NumberOfBits),'_Bits.mat']);
		eval(['save(filename,''Slices'')']);
	end
    
    cd .. % eval(['cd ', DATESTR(datenum(TimeStart),30), '_Files']);

    Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,01) = NumberOfBits;
    Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,02) = size(PRM,1);
    Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,03) = Empty;
    Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,47) = Empty;
    Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,48) = 7777;
    Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,49) = 7777;
    Group_Lines_Of_Slice = 1;
    for Line_Of_PRM = 1:size(PRM,1);
        Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,04:37) = PRM(Line_Of_PRM,:);
        Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,38:40) = Slices(Group_Lines_Of_Slice+0,:);
        Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,41:43) = Slices(Group_Lines_Of_Slice+1,:);
        Table_PRM_Slices_NumberOfBits(Table_PRM_Slices_NumberOfBits_Line_Index,44:46) = Slices(Group_Lines_Of_Slice+2,:);
        Group_Lines_Of_Slice = Group_Lines_Of_Slice + 3;
    end % for Line_Of_PRM = 1:size(PRM,1);
    Table_PRM_Slices_NumberOfBits_Line_Index = Table_PRM_Slices_NumberOfBits_Line_Index + 1;
    
end % for DC = 1:1:5;

% Now that we finished simulating all Initial Condictions, we can save the table of BAD ICs
if Table_PRM_Slices_NumberOfBits(1,1) ~= 987654321;
	filename = (['', DATESTR(datenum(TimeStart),30), '_Table_PRM_Slices_NumberOfBits.mat']);
	eval(['save(filename,''Table_PRM_Slices_NumberOfBits'')']);
end

% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')

% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')

